<?php

namespace App\Repositories;

use App\Interfaces\DeviceInfo as Contract;

use DeviceDetector\DeviceDetector;

class DeviceInfo implements Contract
{

    private $info;

    public function __construct()
    {
        $userAgent = @$_SERVER['HTTP_USER_AGENT'];

        if (empty($userAgent)) {
            abort(422, t('Device is not recognized.'));
        }

        $this->info = new DeviceDetector($userAgent);

        $this->info->parse();
    }

    public function isBot()
    {
        return $this->info->isBot();
    }

    public function getDeviceName()
    {
        return $this->info->getDeviceName();
    }

    public function getDeviceBrand()
    {
        return $this->info->getBrandName();
    }

    public function getDeviceModel()
    {
        return $this->info->getModel();
    }

    public function getOSName()
    {
        return $this->info->getOs()['name'];
    }

    public function getOSVersion()
    {
        return $this->info->getOs()['version'];
    }

    public function getClientType()
    {
        return $this->info->getClient()['type'];
    }

    public function getClientName()
    {
        return $this->info->getClient()['name'];
    }

    public function getClientVersion()
    {
        return $this->info->getClient()['version'];
    }
}
