<?php

namespace App\Repositories;

use App\Interfaces\QRCodeScanManager as QRCodeScanInterface;
use App\Models\QRCode;
use App\Models\QRCodeRedirect;
use App\Models\User;

use App\Models\QRCodeScan as QRCodeScanModel;

class QRCodeScanManager implements QRCodeScanInterface
{
    public function getScanCountOfQrCodesCreatedByUser(User $user)
    {
        $qrcodesIds = QRCode::where('user_id', $user->id)
            ->select('id')
            ->get()
            ->pluck('id');

        $redirectIds = QRCodeRedirect::whereIn('qrcode_id', $qrcodesIds)
            ->select('id')
            ->get()
            ->pluck('id');

        $scanCount = QRCodeScanModel::whereIn('qrcode_redirect_id', $redirectIds)->count();

        return $scanCount;
    }
}
