<?php

namespace App\Repositories;

use App\Interfaces\TransactionManager as TransactionManagerInterface;
use App\Models\File;
use App\Models\OfflinePaymentGatewayModel;
use App\Models\Subscription;
use App\Models\Transaction;
use App\Models\User;

class TransactionManager implements TransactionManagerInterface
{
    public function approveOfflineTransaction(Transaction $transaction, User $user)
    {
        $transaction->status = Transaction::STATUS_SUCESS;

        $transaction->approved_by_id = $user->id;

        $transaction->approved_at = time();

        $transaction->save();
    }

    public function rejectOfflineTransaction(Transaction $transaction, User $user)
    {
        $transaction->status = Transaction::STATUS_FAILED;

        $transaction->rejected_by_id = $user->id;

        $transaction->rejected_at = time();

        $transaction->save();
    }

    public function storeOfflineTransaction($data)
    {
        $transaction = new Transaction();

        $subscription = Subscription::findOrFail(
            $data['subscription_id']
        );

        $transaction->subscription_id = $subscription->id;
        $transaction->amount = $subscription->subscription_plan->yearly_price;
        $transaction->currency = 'USD';
        $transaction->payment_gateway_id = OfflinePaymentGatewayModel::instance()->id;
        $transaction->status = Transaction::STATUS_PENDING_CONFIRMATION;
        $transaction->save();

        $file = File::find($data['payment_proof_id']);

        $file->attachable_id = $transaction->id;

        $file->save();

        $transaction->refresh();

        return $transaction;
    }
}
