<?php

namespace App\Support\QRCodeDataMakers;

use Illuminate\Support\Str;
use App\Interfaces\QRCodeDataMaker;
use App\Models\QRCode;
use InvalidArgumentException;
use App\Exceptions\NotImplementedException;

class BaseMaker implements QRCodeDataMaker
{
    protected QRCode $qrcode;

    public static function instance(QRCode $qrcode): static
    {
        $base = new static;

        $base->init($qrcode);

        $base->verifyType();

        $maker = $base->getTypeClass();

        $makerObject = new $maker;

        $makerObject->init($qrcode);

        return $makerObject;
    }

    public function init(QRCode $qrcode): QRCodeDataMaker
    {
        $this->qrcode = $qrcode;

        return $this;
    }

    public function make(): string
    {
        if (!$this->verify()) return '';

        return $this->makeData();
    }

    protected function makeData(): string
    {
        throw new NotImplementedException();
    }

    protected function verify()
    {
        throw new NotImplementedException();
    }

    private function verifyType()
    {
        $maker = $this->getTypeClass();

        if (!class_exists($maker)) {
            throw new InvalidArgumentException("Type is not supported ({$this->qrcode->type})");
        }
    }

    private function getTypeClass()
    {
        $type = $this->qrcode->type;

        $maker = __NAMESPACE__ . '\\' . ucfirst(strtolower($type)) . 'Maker';

        return $maker;
    }
}
