<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class BarnShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'barn';

    protected function symbolPath()
    {
        return 'm 682.33677,287.62039 c -59.69444,-51.16109 -108.89042,-93.34401 -109.3244,-93.73984 -0.43398,-0.39582 14.18428,-0.71967 32.48503,-0.71967 h 33.27408 l 107.6513,92.03712 c 59.20821,50.62043 108.46086,92.80335 109.45034,93.73984 1.06865,1.01143 -11.76094,1.70271 -31.60099,1.70271 h -33.40001 z m -109.80559,0.005 C 512.8197,236.46773 463.60978,194.2848 463.1758,193.88599 c -0.43399,-0.39881 15.47687,-0.72511 35.35746,-0.72511 h 36.14651 L 643.2461,286.1756 c 59.71148,51.1581 108.92141,93.34103 109.35539,93.73984 0.43397,0.39881 -15.47688,0.72511 -35.35747,0.72511 H 681.0975 Z M 456.55213,286.90071 347.1913,193.16088 h 39.01899 39.019 l 106.47955,91.17687 c 58.56376,50.14727 107.72739,92.3302 109.25252,93.73983 2.33873,2.16162 -3.32032,2.56297 -36.13773,2.56297 H 565.91297 Z M 216.89014,668.0147 c 0.033,-40.44077 0.75382,-69.32948 1.68923,-67.70099 5.68189,9.89184 74.00255,136.76927 74.00255,137.42918 0,0.44737 -17.04361,0.8134 -37.87469,0.8134 h -37.87468 z m 46.29369,-35.80252 -37.9199,-70.72002 37.722,-0.51353 c 20.74709,-0.28243 38.03459,-0.20091 38.41666,0.18116 0.38208,0.38207 0.47113,32.43717 0.19791,71.23355 l -0.49678,70.53887 z m 72.95397,105.15033 c 0,-1.53379 72.05039,-135.50952 74.16134,-137.90099 0.87341,-0.98947 1.58802,29.90207 1.58802,68.64787 v 70.4469 h -37.87468 c -20.83107,0 -37.87468,-0.5372 -37.87468,-1.19378 z m -9.46867,-106.43344 v -70.38378 h 37.87468 c 20.83108,0 37.87468,0.41149 37.87468,0.91442 0,0.9593 -73.7693,137.69528 -75.02532,139.06409 -0.39822,0.43398 -0.72404,-30.88365 -0.72404,-69.59473 z m -193.11211,-86.00709 0.0488,-193.63431 89.43017,-76.3521 c 49.18659,-41.99366 90.00836,-76.50697 90.71503,-76.69623 0.70668,-0.18927 41.39829,33.97247 90.4258,75.91498 l 89.14094,76.25911 v 194.07142 194.07144 h -28.35624 -28.35627 l -0.52318,-97.32977 c -0.49805,-92.65105 -0.69661,-97.52134 -4.13074,-101.31477 -3.59121,-3.96698 -4.12475,-3.985 -117.88495,-3.985 -111.75243,0 -114.36109,0.0837 -118.06487,3.78746 -3.68941,3.68942 -3.78747,6.31245 -3.78747,101.31478 v 97.5273 H 162.86113 133.50825 Z M 235.76989,392.94982 v -21.77794 h 33.14035 33.14035 v 21.77794 21.77794 h 12.30927 12.30927 v -21.77794 -21.77794 h 33.14035 33.14034 v 21.77794 21.77794 h 12.30927 12.30928 v -28.9315 c 0,-23.12034 -0.59214,-29.7769 -2.94798,-33.14035 l -2.94799,-4.20884 h -97.31254 -97.31254 l -2.94799,4.20884 c -2.35585,3.36345 -2.94798,10.02001 -2.94798,33.14035 v 28.9315 h 12.30927 12.30927 z m 282.16638,162.74937 c 0,-145.76851 0.48013,-182.57365 2.36717,-181.45962 1.30194,0.76862 8.33243,6.63704 15.62331,13.04094 7.29087,6.4039 15.36316,13.06886 17.9384,14.81102 4.26675,2.88646 16.49284,3.16756 137.76916,3.16756 h 133.08688 v 166.6486 166.6486 H 671.32873 517.93627 Z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'M 303.40205,261.40463 H 167.6477 c -4.64929,0 -8.42297,3.77354 -8.42297,8.42884 v 41.20376 h 16.85136 v -33.19714 h 51.40124 v 32.94585 h 16.85136 v -32.94585 h 51.484 v 32.94585 h 16.43456 v -41.20376 c -0.0647,-2.26881 -1.04038,-4.40837 -2.70383,-5.94831 -1.66934,-1.53993 -3.87932,-2.33938 -6.14227,-2.22773 z M 687.3916,555.23135 h -52.75399 l -2.51076,-254.51976 -13.58222,0.50216 v 254.0176 H 387.75065 v -278.0723 l 27.55443,23.59402 c 1.50472,1.28724 3.41497,2.00428 5.38991,2.02204 h 246.89449 c 3.4091,-0.0764 6.43614,-2.20412 7.66474,-5.38991 1.1403,-3.23274 0.20573,-6.83008 -2.35699,-9.10476 L 487.7715,129.77321 c -1.50472,-1.28136 -3.41496,-1.99842 -5.39577,-2.02204 H 235.57152 c -1.98081,0.0235 -3.88519,0.74061 -5.38991,2.02204 L 44.800085,288.44596 55.503611,300.91873 83.058048,277.32472 v 278.0723 h -70.451 c -4.6553034,0 -8.4288407,3.76766 -8.4288407,8.42297 0,4.6553 3.7735373,8.42884 8.4288407,8.42884 H 687.39882 c 4.64929,0 8.42297,-3.77354 8.42297,-8.42884 0,-4.65531 -3.77353,-8.42297 -8.42297,-8.42297 z M 357.33122,229.12838 257.81354,143.85288 h 61.09465 l 165.91045,142.23669 h -61.09465 z m -13.14869,-85.2755 h 57.04394 l 165.9255,142.23669 h -57.04395 z m 301.1547,142.23669 h -52.918 L 426.49373,143.85288 h 52.83524 z M 243.74245,419.48 h 60.2475 l -60.2475,111.4787 z M 226.89109,530.96472 167.06041,419.48 h 60.24749 z m -65.39062,-87.13233 60.24749,111.39595 h -60.24749 z m 87.88468,111.39595 60.2475,-111.39595 v 111.39595 z m 76.68205,0 V 411.2221 c 0,-2.23948 -0.88754,-4.37904 -2.46864,-5.96005 -1.58116,-1.58116 -3.72073,-2.46864 -5.96005,-2.46864 H 153.24783 c -4.65531,0 -8.42884,3.77354 -8.42884,8.42884 V 555.22849 H 99.736065 V 262.83126 L 235.57167,146.63225 371.32,262.83126 v 292.39723 z',
            $this->frameId()
        );
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(24%%, 14%%) scale(1.8);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 2;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
