<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

use App\Interfaces\QRCodeProcessor;
use App\Support\QRCodeProcessors\ShapeProcessors\BaseShapeProcessor;
use Illuminate\Support\Facades\Log;
use SVG\Nodes\Shapes\SVGCircle;
use SVG\Nodes\Shapes\SVGPath;
use SVG\Nodes\Structures\SVGClipPath;
use SVG\Nodes\Structures\SVGMask;
use SVG\Nodes\Structures\SVGStyle;



class CircleShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'circle';

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            -$this->output->size / 2,
            $this->output->size * 2
        );
    }

    protected function symbolViewBox()
    {
        return sprintf('%1$s %1$s %2$s %2$s', $this->getViewBoxStart(), $this->getSvgViewBoxSize());
    }

    protected function symbolPath()
    {
        $pos = $this->output->size / 2;

        return sprintf(
            'M%1$s %2$s a%3$s %3$s 0 1 0 %4$s 0 a%3$s %3$s 0 1 0 -%4$s 0Z',
            ($pos + 0.5 - $this->circleRadius()),
            ($pos + 0.5),
            $this->circleRadius(),
            ($this->circleRadius() * 2)
        );
    }

    protected function frameStrokeWidth()
    {
        return $this->getSvgViewBoxSize() / 80;
    }

    protected function circleRadius()
    {
        return $this->output->size - 0.05 * $this->output->size;
    }
}
