<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class GolfShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'golf';

    protected function symbolPath()
    {
        return 'm 436.53754,862.88834 c 0,-34.61103 -0.45196,-37.87516 -7.08841,-51.19276 -5.06755,-10.16926 -11.74835,-17.76227 -23.43376,-26.63346 -22.59515,-17.15352 -34.41236,-30.08728 -43.85708,-48.00091 -8.61822,-16.34604 -13.29172,-32.70923 -9.3421,-32.70923 1.32266,0 8.34812,1.73805 15.61212,3.86232 60.12831,17.58382 134.23104,17.68335 194.15833,0.26077 l 21.1901,-6.16057 -1.58291,7.04457 c -6.04755,26.91389 -23.1768,49.94127 -60.52077,81.35991 -21.53076,18.1145 -26.21634,31.65512 -26.21634,75.76121 v 33.37634 H 465.99713 436.53754 Z M 409.31236,694.80022 C 273.59155,670.24188 170.23544,568.95871 140.29798,431.18125 133.49457,399.87077 133.5294,334.53803 140.36652,302.63032 166.07069,182.67307 247.69536,90.584992 362.31443,52.231057 460.52975,19.366162 566.92635,34.434261 654.65494,93.632908 777.80966,176.73686 830.37293,337.25118 780.32184,477.38639 739.91839,590.50972 640.95176,674.43518 523.88423,694.85006 c -29.18494,5.08944 -86.30719,5.06459 -114.57187,-0.0498 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 349.82042,540.67909 c -34.15191,-0.071 -67.9635,-6.78884 -99.54182,-19.77975 -10.16189,-4.0733 -20.04982,-8.78995 -29.60543,-14.13116 -14.55262,-8.11814 -28.31923,-17.58038 -41.11576,-28.25747 -0.34062,-0.26966 -0.64813,-0.58189 -0.91778,-0.91778 -23.29921,-19.56659 -42.97965,-43.06927 -58.14267,-69.44953 -10.25659,-17.59855 -18.36517,-36.35733 -24.160301,-55.88153 -15.16665,-49.90595 -15.16665,-103.18966 0,-153.09561 -0.0331,-0.20817 -0.0331,-0.42578 0,-0.63394 C 111.29984,149.43539 140.21494,105.74603 179.55764,72.783427 192.35901,62.039606 206.1777,52.577374 220.8151,44.521113 260.26559,22.512938 304.68403,10.96022 349.85819,10.96022 c 45.17417,0 89.59382,11.552839 129.0431,33.560893 14.68463,8.051901 28.55055,17.51377 41.40036,28.262314 23.48936,19.699812 43.3345,43.372043 58.63437,69.941233 23.58867,40.26435 36.04971,86.07798 36.10179,132.74907 0.0521,26.11866 -3.80831,52.10168 -11.44396,77.08069 -5.90413,19.39219 -14.01247,38.04561 -24.1603,55.59693 -15.31441,26.59704 -35.21648,50.27533 -58.78092,69.94123 -12.7832,10.76272 -26.60189,20.22907 -41.25746,28.25747 -9.53744,5.3222 -19.40188,10.04368 -29.53034,14.13116 -31.67278,13.30276 -65.67815,20.17214 -100.03473,20.20605 z M 189.59141,468.19211 c 11.81771,9.8355 24.52,18.55895 37.93661,26.07143 9.10689,5.12357 18.54926,9.63203 28.25747,13.49291 34.81438,14.1033 72.34891,20.21089 109.8362,17.87346 37.49213,-2.33706 73.97663,-13.05206 106.77089,-31.36516 13.87562,-7.65926 26.94222,-16.69991 38.99633,-26.98944 22.34365,-18.58318 41.1969,-40.99828 55.67322,-66.19408 9.59425,-16.64783 17.27276,-34.32753 22.88744,-52.70723 14.40971,-47.5116 14.40971,-98.23141 0,-145.74422 C 584.36711,184.22222 576.63712,166.528 566.91922,149.9274 544.29096,110.86446 511.50154,78.661216 472.03652,56.743874 434.68608,35.899569 392.62445,24.957247 349.84827,24.957247 c -42.77618,0 -84.83417,10.942564 -122.18824,31.786627 -13.84776,7.649815 -26.90951,16.642986 -38.99633,26.842901 -22.24434,18.739405 -41.08305,41.182365 -55.67322,66.340625 -9.52327,16.45405 -17.13469,33.94844 -22.67549,52.13922 v 0.7049 c -14.414561,47.39412 -14.414561,98.00008 0,145.39299 13.918,46.46641 41.13029,87.8474 78.27726,119.03817 z m 234.68766,220.84717 h -148.9173 c -3.90303,0 -7.06316,-3.16498 -7.06316,-7.06315 0,-3.90303 3.16025,-7.06788 7.06316,-7.06788 h 148.9173 c 3.90302,0 7.06788,3.16497 7.06788,7.06788 0,3.8983 -3.16498,7.06315 -7.06788,7.06315 z m -44.71395,0 h -59.27746 c -3.8983,0 -7.06316,-3.16498 -7.06316,-7.06315 v -48.11352 c -0.0946,-13.81385 -7.30441,-26.60189 -19.07488,-33.83945 -29.39349,-18.60618 -47.5116,-50.70043 -48.25037,-85.48211 -0.0426,-2.36541 1.09756,-4.58899 3.03721,-5.9372 1.95859,-1.38138 4.48483,-1.67471 6.70842,-0.77585 60.48009,24.44491 128.08632,24.44491 188.56884,0 2.3086,-1.05026 5.00524,-0.7806 7.06315,0.7049 1.93971,1.34832 3.07984,3.57651 3.03721,5.93719 -0.81844,34.86646 -19.07488,66.99825 -48.60522,85.55357 -11.74674,7.25718 -18.95135,20.03044 -19.07489,33.83945 v 48.11351 c 0,3.8983 -3.16497,7.06316 -7.06315,7.06316 z m -52.20946,-14.13116 h 45.14146 v -41.04551 c 0.11348,-18.65342 9.79759,-35.94071 25.64633,-45.78093 22.21164,-14.05122 37.13729,-37.13728 40.83236,-63.15663 -57.6122,20.39014 -120.48543,20.39014 -178.09279,0 3.71373,25.99634 18.6401,49.05454 40.83236,63.08639 15.85819,9.83077 25.54702,27.12266 25.64633,45.78093 z',
            $this->frameId()
        );
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-7.5%%, -18%%) scale(3);
        }

        #%2$s path {
            transform: scale(0.75);
        }
        
        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor
        );
    }

    protected function frameStrokeWidth()
    {
        return 7;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
