<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class HomeMoverShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'home-mover';

    protected function symbolPath()
    {
        return 'm 140.45555,452.37528 c -31.55464,0 -57.215015,25.66037 -57.215015,57.21501 0,31.56506 25.660375,57.07299 57.215015,57.07299 31.55463,0 57.07299,-25.50793 57.07299,-57.07299 -0.005,-31.55985 -25.51836,-57.21501 -57.07299,-57.21501 z M 37.201697,289.69673 c 5.043609,3.8985 12.265515,2.96707 16.18447,-2.05608 L 201.78507,97.028187 425.64723,187.92544 c 5.90885,2.39197 12.58094,-0.43769 15.00926,-6.32617 2.42259,-5.89348 -0.27483,-12.60648 -6.17855,-15.00926 l -67.3632,-27.36064 -13.68032,-50.88949 c -1.64894,-6.153147 -7.82241,-9.731007 -13.97087,-8.081942 l -35.00468,9.267831 c -6.15823,1.648934 -9.731,7.964943 -8.0921,14.118091 l 2.05608,7.79192 -95.89904,-38.974582 c -1.84749,-0.707429 -3.73564,-0.895735 -5.58822,-0.737969 -0.6209,0.05089 -1.14002,0.167956 -1.76606,0.300277 -2.52943,0.641268 -4.56011,2.320703 -6.32617,4.117385 L 35.141702,273.67168 c -3.908663,5.02837 -2.98244,12.14839 2.056087,16.03204 z M 610.5374,347.94884 c -14.18453,-72.72198 -80.65135,-128.7722 -162.53523,-134.14531 -9.00321,0.80921 -12.69299,5.32855 -12.64205,14.56107 0.15269,46.05968 0.77359,93.05484 1.17565,132.5167 h -12.79983 c 0.92118,-4.04104 0.86012,-8.34656 -0.2901,-12.64205 L 380.93913,189.39119 232.24057,128.20629 c -3.18087,-1.31305 -6.63144,-2.06625 -10.14833,-2.20371 -3.51675,-0.14759 -6.99794,0.25447 -10.4485,1.17565 -6.88602,1.8475 -13.309,5.72554 -17.503,11.1763 L 92.357856,270.5846 116.61893,361.19131 c -20.3472,0.0152 -55.108242,0 -66.044681,0 -9.318643,0 -16.764255,7.45095 -16.764255,16.76426 v 121.93204 c 0,9.31864 7.450954,16.76425 16.764255,16.76425 H 77.93489 c -0.264643,-2.3207 -0.442774,-4.67202 -0.442774,-7.06412 0,-34.82619 28.118924,-63.08843 62.950324,-63.08843 34.8314,0 63.09885,28.26615 63.09885,63.08843 0,2.39197 -0.18321,4.73313 -0.44278,7.06412 h 267.40466 c -0.25446,-2.31054 -0.30027,-4.6771 -0.30027,-7.06412 0,-35.38122 28.6075,-63.9783 63.98872,-63.9783 35.38121,0 63.98872,28.60229 63.98872,63.9783 0,2.38689 -0.18831,4.74329 -0.44278,7.06412 h 69.86214 c 13.7155,-17.68018 21.77256,-39.14265 21.77256,-62.50864 0,-52.75652 -24.39918,-96.64299 -78.83513,-106.19576 z m -52.80603,16.33209 -16.32649,-0.2901 18.0932,-6.32618 z m 11.03389,0.2901 10.73866,-40.29832 c 0.7685,-2.86023 -0.81939,-5.70521 -3.67961,-6.47379 -2.86531,-0.76849 -5.85283,0.8194 -6.61619,3.67962 l -3.38452,12.64205 c -2.77879,-1.37924 -6.09204,-1.85258 -9.26783,-0.73797 l -24.85649,8.83006 c -3.71531,-13.9852 -16.47501,-24.26628 -31.62108,-24.26628 -13.00855,0 -24.16466,7.52717 -29.4166,18.53097 l -0.88046,-102.52162 c 62.94511,2.55991 127.83021,65.48574 128.9963,131.20078 z m -70.4586,-103.69417 c -15.09525,0 -27.36064,12.25522 -27.36064,27.36064 0,15.10542 12.26552,27.2082 27.36064,27.2082 15.09526,0 27.36064,-12.11282 27.36064,-27.2082 0,-15.10047 -12.25522,-27.36064 -27.36064,-27.36064 z m 35.75124,191.49842 c -31.55463,0 -57.06257,25.66037 -57.06257,57.21501 0,31.56506 25.50794,57.07299 57.06257,57.07299 31.55464,0 57.21501,-25.50793 57.21501,-57.07299 0,-31.55985 -25.66037,-57.21501 -57.21501,-57.21501 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(-11%%, -1%%) scale(1.8);
        }

        #%2$s path {
            transform: scale(1);
        }
        
        #%3$s {
            fill: none;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId());
    }

    protected function frameStrokeWidth()
    {
        return 7;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
