<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class LegalShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'legal';

    protected function symbolPath()
    {
        return 'm 346.78392,23.452961 c -8.85085,8.850841 -13.97178,19.952463 -15.68445,31.418062 -9.03754,0.469482 -17.95299,3.969186 -24.79136,10.808801 -15.1354,15.140878 -13.00672,33.097953 -5.78852,46.121896 L 188.55416,223.76714 c -12.24927,-9.42158 -32.19655,-7.39971 -46.1219,5.78852 -6.94614,6.94615 -10.478,16.02589 -10.8514,25.20793 -11.64096,1.6538 -22.92437,6.74879 -31.882417,15.7063 -22.022962,22.02297 -22.022962,58.08189 0,80.10486 L 215.51669,466.29603 c 22.02296,22.02295 57.98083,22.02843 80.00925,0 8.97349,-8.97349 14.1384,-20.25157 15.78142,-31.88243 9.15485,-0.38946 18.20838,-3.92657 25.13826,-10.8514 14.1111,-14.11109 13.00673,-33.03924 5.80984,-46.05224 l 27.63489,-27.6349 192.13584,226.36192 c 26.28004,26.28006 63.24721,28.66468 91.21808,0.69889 24.94706,-24.94707 26.12025,-66.75723 -0.44281,-90.95724 C 576.87858,422.28891 500.94204,358.47763 425.03281,294.7169 l 29.22464,-29.22464 c 14.48941,8.48262 33.54183,6.6794 45.91293,-5.69252 7.0102,-7.61837 9.14954,-16.79481 10.94743,-24.81322 11.49702,-1.73384 22.65258,-6.9195 31.5082,-15.77595 22.02843,-22.02843 21.93282,-57.98629 -0.096,-80.01472 L 426.7814,23.447253 c -22.83423,-22.83422813 -57.01523,-22.3002134 -80.01472,0 z M 342.93205,82.597415 483.401,223.06637 c 6.09786,6.09787 4.90829,14.81582 0,19.72302 -5.20699,5.20697 -13.73823,6.19401 -19.81453,0.11732 L 323.09022,102.45142 c -5.61248,-5.612483 -6.73814,-12.985435 0,-19.723026 6.7115,-6.49271 14.51126,-5.148248 19.84047,-0.117376 z M 179.19047,246.33901 319.65942,386.82161 c 5.61247,5.61247 5.61247,14.08923 0,19.70252 -7.03684,7.03685 -14.65467,5.3243 -19.84047,0.13871 L 159.35001,266.18024 c -5.61248,-5.61247 -5.61248,-14.08923 0,-19.69706 6.12996,-5.5644 14.16434,-5.64976 19.84046,-0.13871 z m -57.27746,271.66434 c -26.03011,0 -35.361016,19.40343 -35.361016,44.60589 103.392516,-0.72557 207.541666,-0.34679 296.316406,0 0,-27.36857 -13.98817,-43.94486 -35.38698,-44.60589 z m -32.282583,68.20357 c -20.310284,0 -38.278295,15.25287 -38.278295,35.45663 v 43.06394 c -0.02665,6.59938 5.302998,11.97175 11.902375,11.99852 l 342.807043,-0.005 c 6.59937,-0.0267 11.92914,-5.39901 11.90237,-11.99852 v -43.06394 c 0,-20.1983 -17.96802,-35.45663 -38.27831,-35.45663 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(4%%, -7%%) scale(1.15);
        }
        
        #%3$s {
            fill: none;
            stroke: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 15;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
