<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class PainterShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'painter';

    protected function symbolPath()
    {
        return 'm 660.33892,332.61046 27.83382,-103.87723 -35.51681,-9.51669 4.65378,-17.36811 c 3.04316,-11.35725 -3.72235,-23.07209 -15.07738,-26.11468 L 468.10535,129.07658 c -11.35724,-3.04316 -23.07206,3.72225 -26.11464,15.07729 l -4.65377,17.36811 -14.64125,-3.92311 -5.17584,19.3165 14.58509,3.90807 -4.65376,17.3681 c -3.04316,11.35722 3.72226,23.07206 15.07729,26.11463 l 174.07186,46.64241 c 11.35736,3.0432 23.07215,-3.72222 26.11472,-15.07727 l 4.65376,-17.3681 16.20042,4.3409 -17.48095,65.23981 -133.43612,-35.7541 -11.15728,41.63953 -23.26942,-6.23503 -22.85212,85.28525 c -4.86236,18.14658 5.9205,36.90766 24.12493,41.78552 18.14656,4.86237 36.90761,-5.9205 41.78546,-24.12489 l 22.85212,-85.28524 -23.26942,-6.23502 5.98144,-22.32303 z M 244.13845,144.04232 h -35 c -51.055,0 -100.02,20.281 -136.12,56.383 -36.101999,36.102 -56.382999,85.062 -56.382999,136.12 v 8.75 h 26.25 v -17.5 h -8.75 c 2.2461,-44.879 21.672,-87.176 54.249999,-118.12 32.578,-30.944 75.812,-48.18 120.75,-48.125 h 35 c 44.938,-0.0547 88.172,17.176 120.75,48.125 32.578,30.949 52.004,73.246 54.25,118.12 h -8.75 v 17.5 h 26.25 v -8.75 c 0,-51.055 -20.281,-100.02 -56.383,-136.12 -36.102,-36.102 -85.062,-56.383 -136.12,-56.383 z m -183.749999,175 H 392.88845 v 26.25 H 60.388451 Z m 17.499199,280.0015 c 0,13.926 5.5312,27.277 15.375,37.125 9.8477,9.8438 23.199,15.375 37.125,15.375 h 192.5 c 13.926,0 27.277,-5.5312 37.125,-15.375 9.8438,-9.8477 15.375,-23.199 15.375,-37.125 v -236.25 l -295.943601,1.66989 c 0,0 -0.552095,197.62782 -1.556399,234.58011 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-18.5%%, 21%%) scale(2.2);
        }

        #%2$s path {
            transform: scale(1);
        }
        
        #%3$s {
            fill: none;
        }

        .foreground-1 {
            mask: url(#%s);
        }',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor
        );
    }

    protected function frameStrokeWidth()
    {
        return 7;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
