<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class PestShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'pest';

    protected function symbolPath()
    {
        return 'm 842.58302,228.65999 c -6.32204,-6.24076 -10.99248,-16.00334 -12.17185,-25.44272 -1.04587,-8.37089 -0.0652,-9.55519 7.93827,-9.5869 5.9414,-0.0236 13.73733,3.97012 17.388,8.90747 2.78265,3.76339 4.28941,13.07491 2.96781,18.34056 -0.85417,3.4033 -8.24841,12.78874 -10.07549,12.78874 -0.53591,0 -3.25694,-2.25322 -6.04674,-5.00715 z m -45.7242,17.07171 c -7.75321,-4.72738 -11.63672,-16.23379 -8.37475,-24.81342 1.12087,-2.94812 1.98568,-3.45635 4.9252,-2.89442 4.88444,0.93372 18.20645,-1.08109 23.01747,-3.48115 l 3.95295,-1.97199 2.16785,6.52678 c 1.19232,3.58974 2.72277,6.86975 3.401,7.28892 2.60955,1.61279 1.03367,4.1459 -3.62784,5.83153 -2.67355,0.96677 -8.20125,4.99305 -12.28379,8.9473 -4.08253,3.95425 -7.75346,7.1873 -8.1576,7.18455 -0.40415,-0.003 -2.66337,-1.18089 -5.02049,-2.6181 z m 69.03621,90.83666 c -8.56016,-2.60388 -21.35521,-11.88121 -21.35521,-15.48405 0,-2.77646 9.1981,-9.64812 14.16072,-10.57912 10.66119,-2.00005 23.11662,6.50671 25.1137,17.15207 1.58823,8.46595 0.28568,10.17555 -7.65243,10.0439 -3.80602,-0.0631 -8.42607,-0.57288 -10.26678,-1.1328 z m -22.06488,43.89228 c -4.48424,-1.30435 -12.09948,-8.11904 -13.30013,-11.90194 -0.55163,-1.73803 1.2879,-4.4943 6.43395,-9.64035 3.96354,-3.96354 8.01429,-9.44053 9.00167,-12.17108 0.98738,-2.73055 2.122,-4.79965 2.52138,-4.59799 0.39938,0.20165 4.45946,1.78505 9.02241,3.51865 l 8.29626,3.15202 -2.18868,4.17848 c -1.29544,2.47317 -2.43329,8.66737 -2.78805,15.17745 l -0.59937,10.99897 -4.8406,1.34457 c -5.54645,1.54063 -6.06934,1.53797 -11.55884,-0.0588 z M 258.70291,179.37321 c -1.10946,-0.44768 -1.66905,-3.76991 -1.66905,-9.9089 v -9.23541 h 33.38102 33.38102 v 9.20383 c 0,7.16094 -0.4688,9.38372 -2.11207,10.0143 -2.5166,0.96571 -60.57334,0.89766 -62.98092,-0.0738 z m 23.70052,36.26818 v -15.35527 h 8.67907 8.67906 v 15.35527 15.35527 h -8.67906 -8.67907 z m 106.81927,73.43825 c 0,-17.28117 0.11305,-18.02575 2.73679,-18.02575 4.63186,0 10.15561,3.67734 11.91919,7.93499 1.0185,2.45886 1.45733,7.54789 1.11477,12.92765 -0.48759,7.65753 -1.06772,9.3049 -4.23659,12.03065 -2.06274,1.7743 -5.3943,3.15821 -7.6029,3.15821 h -3.93126 z m -174.04198,35.61255 c -1.93056,-2.13324 -2.20981,-6.60471 -2.20981,-35.38388 0,-31.16175 0.14432,-33.0864 2.67048,-35.61255 2.60496,-2.60497 4.45081,-2.67049 75.23416,-2.67049 72.07432,0 72.58083,0.019 75.1073,2.81067 2.35437,2.60155 2.54362,5.22365 2.54362,35.2437 0,30.02005 -0.18925,32.64214 -2.54362,35.2437 -2.52684,2.79212 -3.02531,2.81066 -75.56797,2.81066 -69.04906,0 -73.14465,-0.13293 -75.23416,-2.44181 z m -55.9055,547.18053 c -13.56855,-2.28635 -25.0343,-11.12671 -30.90874,-23.83137 l -2.85384,-6.17201 V 640.91559 439.96185 l 3.71168,-7.55819 c 4.30597,-8.76836 12.05514,-16.2842 20.82683,-20.19974 5.04957,-2.25404 10.05729,-2.90523 27.53588,-3.58069 19.14763,-0.73996 22.12568,-1.18099 28.70768,-4.25146 19.25497,-8.98233 30.71054,-28.17251 30.71054,-51.4458 v -5.76336 h 53.91798 53.91799 l 0.54345,12.42575 c 0.44673,10.21389 1.21151,13.79117 4.29637,20.0964 4.82425,9.86042 14.64824,19.64117 24.45684,24.34921 7.12857,3.42165 9.43117,3.78389 29.10485,4.57881 25.8289,1.04362 31.83345,3.05558 41.85985,14.02605 11.84217,12.95722 10.96565,-5.37073 10.56655,220.94725 l -0.35201,199.6185 -3.56819,6.76094 c -3.7414,7.08914 -11.59045,15.05456 -18.20533,18.47524 -2.14902,1.1113 -7.74286,2.6429 -12.43074,3.40356 -10.1131,1.64094 -252.1121,1.66719 -261.83764,0.0284 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 568.67418,149.3504 c -1.47202,-1.7286 -2.74865,-3.61488 -3.80738,-5.62386 -2.26137,-3.75588 -2.81228,-8.29894 -1.51517,-12.48573 1.82922,-3.99151 5.26791,-7.01599 9.46056,-8.3214 9.87447,-3.27837 20.6428,-2.53273 29.97279,2.07539 9.19746,4.79218 20.95945,16.92491 16.80771,27.74216 -4.15174,10.81724 -20.96424,12.03192 -31.03418,9.45693 -7.76162,-2.19849 -14.68676,-6.67217 -19.88409,-12.84326 z m 40.11985,-10.22435 c -2.60128,-3.11564 -5.77093,-5.70951 -9.3388,-7.64599 -7.46853,-3.66001 -16.06651,-4.28185 -23.98364,-1.73401 -2.19858,0.60585 -4.06348,2.06583 -5.17667,4.05699 -0.50872,2.23721 -0.094,4.58546 1.1499,6.51161 4.16825,7.19127 10.98463,12.46617 18.99276,14.69337 8.30929,2.135 20.23194,0.51935 22.34302,-4.84733 1.09955,-3.03258 -0.75298,-7.18106 -3.98666,-11.03482 z m -6.76139,86.82646 c -1.41237,-1.73159 -2.5109,-3.69876 -3.24412,-5.80949 -3.23024,-9.83756 -2.48039,-20.54975 2.08951,-29.84106 4.89616,-9.18844 17.1168,-20.78688 27.8801,-16.58715 8.46966,3.29495 11.24094,15.11016 10.24525,25.29236 v 0 c -0.18639,2.05014 -1.99864,3.56012 -4.04758,3.37284 -2.05018,-0.1864 -3.56019,-1.99867 -3.37284,-4.04759 0.97172,-7.23961 -0.84009,-16.02465 -5.39685,-17.85665 -5.36652,-2.11123 -14.57893,5.47535 -18.66716,13.17062 -3.73469,7.4435 -4.4237,16.05023 -1.91653,23.99331 0.56972,2.19887 2.01771,4.0699 4.00385,5.17197 3.9073,1.5147 12.54142,-3.33359 17.98866,-12.26547 1.05824,-1.73531 3.32398,-2.28409 5.05924,-1.22579 1.73535,1.05821 2.28412,3.32395 1.22581,5.05918 -6.38713,10.15289 -18.08784,18.77246 -26.95763,15.28662 v 0 c -1.91307,-0.80844 -3.5944,-2.08535 -4.88803,-3.71119 z m -21.06837,47.15601 c -0.80718,-0.95107 -1.45254,-2.02943 -1.91071,-3.19005 -1.4007,-4.19146 -0.89281,-8.78594 1.38732,-12.57167 5.05009,-9.0866 13.48959,-15.80645 23.47634,-18.69316 10.03826,-2.71822 26.91352,-1.6854 31.1306,9.10891 4.21708,10.7943 -7.33035,23.02406 -16.51538,27.90227 v 0 c -9.27354,4.6957 -20.02306,5.55435 -29.92232,2.38628 -2.93574,-0.95613 -5.57002,-2.65972 -7.64704,-4.9438 z M 605.8833,245.6812 c -7.97834,2.33782 -14.72886,7.69398 -18.82126,14.93055 -1.29785,1.93428 -1.74152,4.31794 -1.2283,6.58975 1.15438,1.98015 3.04072,3.42743 5.25102,4.02902 7.93401,2.47573 16.51979,1.76997 23.94252,-1.96967 7.68307,-4.09726 15.27138,-13.38989 13.07746,-18.68969 -2.19492,-5.30117 -14.01007,-6.98536 -22.41809,-4.72352 z m 74.55748,39.43971 c -0.38542,-0.46401 -0.65008,-1.01447 -0.7717,-1.60572 -0.23876,-1.02153 -0.5513,-2.02395 -0.93605,-3.00012 -0.7268,-1.9067 0.23126,-4.03939 2.13655,-4.76506 1.90543,-0.72566 4.03938,0.23124 4.76507,2.13652 0.50771,1.33955 0.90967,2.71626 1.20341,4.11956 0.33912,1.64353 -0.48009,3.30672 -1.98839,4.04155 -1.50829,0.73484 -3.32376,0.35387 -4.40901,-0.92675 z m -25.88252,17.88338 c -3.68461,-4.3787 -6.3581,-9.5155 -7.83152,-15.04573 -2.76152,-10.43194 -1.02253,-27.03959 9.3111,-31.06081 6.094,-2.33373 13.82739,0.42782 20.73451,7.28707 0.6962,0.6869 1.08992,1.62537 1.09158,2.60408 0.003,0.97765 -0.3853,1.9176 -1.07871,2.60857 -0.68802,0.69742 -1.62541,1.09002 -2.60431,1.09396 -0.97875,0.002 -1.91861,-0.38659 -2.60963,-1.08005 -4.64722,-4.68148 -9.69428,-6.86845 -12.87735,-5.63544 -5.39491,2.08315 -7.05596,13.92581 -4.875,22.35234 2.26852,7.98495 7.55269,14.77464 14.73672,18.93458 1.92784,1.25189 4.28271,1.66626 6.52042,1.14296 2.70181,-1.74285 4.4683,-4.61589 4.80135,-7.81424 0.46135,-1.97489 2.43512,-3.20316 4.41004,-2.74177 1.97508,0.45904 3.2031,2.43509 2.74175,4.40998 -0.76405,5.60779 -4.2423,10.48018 -9.29718,13.02471 -4.19715,1.31999 -8.75835,0.78801 -12.53955,-1.46132 -4.07133,-2.15392 -7.68395,-5.08215 -10.63457,-8.61898 z m -25.81798,-54.93078 -0.73233,-0.87275 c -1.30338,-1.55331 -1.10074,-3.86969 0.45259,-5.17309 1.55333,-1.30341 3.86972,-1.10073 5.1731,0.45258 3.16318,3.98141 7.24236,7.13666 11.8885,9.19779 4.6409,2.03955 9.71278,2.90471 14.76627,2.51815 2.08537,-0.14913 3.8969,1.42071 4.04617,3.50616 0.14795,2.08644 -1.42196,3.89797 -3.50739,4.04731 -12.2999,0.95649 -24.30095,-4.10663 -32.19991,-13.58094 z m -9.52943,37.42445 c -2.79492,-3.33396 -4.62378,-7.36953 -5.28536,-11.6696 -0.0561,-1.83164 1.2456,-3.42467 3.05272,-3.73196 1.80604,-0.3086 3.56244,0.76197 4.11709,2.50935 0.9147,5.61162 4.6204,10.37469 9.83749,12.63933 5.21576,2.26564 11.22528,1.72109 15.95051,-1.4435 0.80693,-0.5557 1.80303,-0.76609 2.76682,-0.58402 0.96272,0.1808 1.81315,0.74035 2.36102,1.55392 0.54487,0.80748 0.74784,1.79911 0.55943,2.75533 -0.18612,0.95639 -0.7451,1.79994 -1.55254,2.34484 -6.82335,4.65765 -15.5702,5.45155 -23.11902,2.09391 -3.3468,-1.47149 -6.31691,-3.68252 -8.68781,-6.46724 z m 5.74455,-41.24959 c -0.90429,-1.06213 -1.12686,-2.54668 -0.57715,-3.82969 l 1.0406,-2.3582 c 3.4488,-7.86058 10.82871,-13.28273 19.36002,-14.22709 8.5313,-0.94435 16.91801,2.7368 22.00044,9.65296 5.08242,6.91615 6.08819,16.01823 2.63951,23.87896 l -0.99367,2.1285 c -0.32807,0.9836 -1.05536,1.7821 -2.00538,2.20043 -0.9487,0.41735 -2.02941,0.4147 -2.97679,-0.008 -0.94616,-0.42376 -1.6694,-1.22699 -1.99153,-2.21276 -0.32212,-0.98576 -0.21292,-2.06181 0.30097,-2.96166 l 0.91402,-2.10865 0.001,-9.1e-4 c 1.95534,-5.3512 1.04147,-11.33149 -2.4223,-15.8544 -3.46474,-4.5244 -8.99919,-6.96582 -14.67486,-6.47453 -5.67695,0.49223 -10.70859,3.84984 -13.34276,8.90191 l -1.01298,2.33502 c -0.3947,0.89396 -1.12836,1.59312 -2.0398,1.94265 -0.91029,0.35093 -1.9237,0.32393 -2.81517,-0.0729 -0.53423,-0.19804 -1.01363,-0.51688 -1.40435,-0.93154 z m -1.26233,-69.25751 c -6.40607,-7.67785 -9.53911,-17.56526 -8.72066,-27.53027 0.13984,-2.02399 1.89539,-3.55052 3.92044,-3.40947 2.02507,0.14103 3.55157,1.89663 3.40946,3.92043 -0.36696,5.05844 0.5135,10.12925 2.56616,14.76911 2.05279,4.63707 5.20269,8.70461 9.18001,11.85325 1.393,1.30055 1.5586,3.45135 0.3814,4.95054 -1.17719,1.49921 -3.30445,1.84835 -4.8992,0.80479 -2.12729,-1.5789 -4.08321,-3.37427 -5.83775,-5.35818 z m -35.66513,11.42162 c -1.4469,-1.73678 -2.64627,-3.66628 -3.56512,-5.73292 -3.21384,-7.35446 -2.56098,-15.82579 1.74348,-22.6007 0.48327,-0.89555 1.31533,-1.54879 2.299,-1.80717 0.98243,-0.25728 2.02843,-0.0971 2.88869,0.44355 0.86006,0.54298 1.45742,1.41554 1.64929,2.41437 0.19186,0.99883 -0.0393,2.03159 -0.63591,2.85322 -2.98751,4.71518 -3.43293,10.60581 -1.19239,15.71635 2.25187,5.1038 6.91995,8.73397 12.42035,9.66078 2.00113,0.33451 3.35161,2.22703 3.01844,4.22715 -0.33316,2.00012 -2.22474,3.35183 -4.22586,3.01739 -5.62082,-0.93262 -10.72624,-3.83699 -14.40007,-8.19243 z m 43.33154,-3.14038 c -0.24675,-0.23806 -0.46798,-0.50171 -0.66064,-0.78733 -0.81622,-1.85512 0.0273,-4.0223 1.88252,-4.83865 l 2.82054,-1.26465 7.7e-4,-6.3e-4 c 5.45614,-2.38492 9.22451,-7.50068 9.88544,-13.41783 0.66189,-5.91794 -1.88396,-11.73966 -6.67824,-15.27272 -4.7944,-3.53075 -11.10886,-4.23683 -16.56396,-1.85068 l -3.47349,1.57291 c -1.8424,0.80339 -3.98894,-0.0232 -4.81654,-1.85616 -0.40264,-0.89044 -0.43254,-1.90533 -0.0826,-2.81953 0.34764,-0.91438 1.04737,-1.65136 1.94184,-2.04665 l 3.4735,-1.57293 c 5.81217,-2.61084 12.4299,-2.77318 18.36327,-0.45286 7.91354,3.07075 13.61725,10.09008 15.00363,18.46461 1.38845,8.37451 -1.74953,16.85818 -8.25042,22.31533 -1.72648,1.46174 -3.65857,2.66328 -5.73295,3.56508 l -2.7929,1.24152 c -1.49733,0.6765 -3.26132,0.27781 -4.31959,-0.97832 z m -221.24148,49.76115 -4.38745,-1.68083 c -3.64092,-1.40145 -7.6527,0.46717 -9.04934,4.01179 -1.40145,3.64091 0.46716,7.6527 4.01178,9.04933 l 4.38745,1.68084 c 0.838,0.27933 1.68083,0.46716 2.51884,0.46716 2.7981,0 5.50472,-1.68082 6.53063,-4.47892 1.40145,-3.63612 -0.37085,-7.6479 -4.01178,-9.04936 z m 35.07642,13.42645 -8.77009,-3.35686 c -3.64092,-1.40145 -7.6527,0.46717 -9.04935,4.01178 -1.40145,3.64092 0.46717,7.6527 4.01179,9.04935 l 8.77008,3.35685 c 0.83801,0.27934 1.68084,0.46717 2.51886,0.46717 2.79809,0 5.50471,-1.68083 6.53062,-4.47894 1.40145,-3.64092 -0.46235,-7.65269 -4.01179,-9.04934 z m 70.06655,26.7789 -8.7701,-3.35685 c -3.64092,-1.40146 -7.6527,0.46715 -9.04934,4.01178 -1.40146,3.64092 0.46716,7.6527 4.01177,9.04935 l 8.86639,3.44833 c 0.838,0.27933 1.68084,0.46716 2.51884,0.46716 2.7981,0 5.50472,-1.68083 6.53063,-4.47892 1.30516,-3.63612 -0.46718,-7.7442 -4.10807,-9.14096 z m -34.9778,-13.34013 -8.77008,-3.35687 c -3.64093,-1.40145 -7.65272,0.46717 -9.04936,4.01179 -1.40145,3.64093 0.46717,7.6527 4.01178,9.04935 l 8.7701,3.35685 c 0.838,0.27933 1.68083,0.46717 2.51884,0.46717 2.79811,0 5.50472,-1.68084 6.53063,-4.47893 1.39665,-3.63612 -0.46717,-7.73938 -4.01178,-9.04935 z m 65.67737,25.10214 -4.38745,-1.68083 c -3.64092,-1.40147 -7.6527,0.46715 -9.04935,4.01177 -1.40146,3.64092 0.46716,7.65271 4.01178,9.04936 l 4.38745,1.68083 c 0.838,0.27933 1.68083,0.46716 2.51884,0.46716 2.7981,0 5.50472,-1.68083 6.53063,-4.47894 1.40145,-3.64092 -0.37083,-7.65269 -4.01178,-9.04934 z m -6.90433,-133.98083 c 0.83801,0 1.68083,-0.18783 2.51885,-0.46717 l 4.38745,-1.68083 c 3.64093,-1.40146 5.41323,-5.41324 4.01177,-9.04935 -1.40145,-3.64091 -5.41323,-5.41323 -9.04934,-4.01178 l -4.38745,1.68084 c -3.64092,1.40145 -5.41324,5.41323 -4.01178,9.04934 1.11732,2.70661 3.72759,4.47893 6.53062,4.47893 z m -70.06653,26.76657 c 0.838,0 1.68083,-0.18782 2.51884,-0.46717 l 8.7701,-3.35684 c 3.6409,-1.40146 5.41323,-5.41324 4.01177,-9.04935 -1.40145,-3.64092 -5.41323,-5.41324 -9.04935,-4.01179 l -8.77009,3.35686 c -3.64091,1.40146 -5.41323,5.41323 -4.01177,9.04935 1.02581,2.7981 3.7324,4.47893 6.53062,4.47893 z m 35.07642,-13.34014 c 0.838,0 1.68084,-0.18782 2.51884,-0.46716 l 8.77009,-3.35685 c 3.64092,-1.40146 5.41323,-5.41324 4.01178,-9.04935 -1.40145,-3.64092 -5.41324,-5.41324 -9.04934,-4.01178 l -8.7701,3.35685 c -3.64092,1.40146 -5.41324,5.41323 -4.01177,9.04936 1.02582,2.70661 3.63611,4.47892 6.53063,4.47892 z m -70.16518,26.77891 c 0.83801,0 1.68084,-0.18782 2.51885,-0.46716 l 8.77009,-3.35687 c 3.64092,-1.40145 5.41323,-5.41323 4.01178,-9.04933 -1.40145,-3.64093 -5.41324,-5.41324 -9.04934,-4.01179 l -8.7701,3.35687 c -3.64092,1.40144 -5.41324,5.41323 -4.01178,9.04933 1.02582,2.7981 3.73241,4.47894 6.53063,4.47894 z m -30.68724,11.762 c 0.838,0 1.68083,-0.18781 2.51884,-0.46716 l 4.38745,-1.68084 c 3.64092,-1.40145 5.41324,-5.41322 4.01178,-9.04934 -1.40145,-3.64092 -5.41323,-5.41323 -9.04934,-4.01178 l -4.38744,1.68083 c -3.64093,1.40146 -5.41325,5.41323 -4.01179,9.04936 1.11732,2.70662 3.72759,4.47892 6.53062,4.47892 z m 150.02106,6.99063 h -4.66683 c -3.82402,0 -6.99778,3.17377 -6.99778,6.99778 0,3.82401 3.17376,6.99777 6.99778,6.99777 h 4.66683 c 3.824,0 6.99777,-3.17376 6.99777,-6.99777 0,-3.9203 -3.16897,-6.99778 -6.99777,-6.99778 z m -70.35012,0 h -9.32872 c -3.82401,0 -6.99778,3.17377 -6.99778,6.99778 0,3.82401 3.17377,6.99777 6.99778,6.99777 h 9.32872 c 3.82401,0 6.99779,-3.17376 6.99779,-6.99777 0,-3.9203 -3.07749,-6.99778 -6.99779,-6.99778 z m -37.50526,0 h -9.32873 c -3.824,0 -6.99777,3.17377 -6.99777,6.99778 0,3.82401 3.17377,6.99777 6.99777,6.99777 h 9.32873 c 3.82402,0 6.99777,-3.17376 6.99777,-6.99777 0,-3.9203 -3.07747,-6.99778 -6.99777,-6.99778 z m 75.02285,0 h -9.32871 c -3.82402,0 -6.99779,3.17377 -6.99779,6.99778 0,3.82401 3.17377,6.99777 6.99779,6.99777 h 9.32871 c 3.82401,0 6.99778,-3.17376 6.99778,-6.99777 0,-3.9203 -3.07748,-6.99778 -6.99778,-6.99778 z m -112.52811,0 h -4.66683 c -3.82402,0 -6.99778,3.17377 -6.99778,6.99778 0,3.82401 3.17376,6.99777 6.99778,6.99777 h 4.66683 c 3.824,0 6.99777,-3.17376 6.99777,-6.99777 0,-3.9203 -3.07748,-6.99778 -6.99777,-6.99778 z m -34.42298,-13.34013 -20.7142,-4.01179 c -4.84979,-0.93432 -9.70439,0.37084 -13.52878,3.45316 -3.73239,3.17376 -5.87557,7.74417 -5.87557,12.59422 v 1.21365 l -15.118,-0.005 c -1.58454,-11.84756 -11.66449,-21.0853 -23.88279,-21.0853 h -4.29117 c -2.51883,-8.67861 -10.54239,-15.11307 -20.0595,-15.11307 h -30.97699 v -24.35006 h 1.86379 c 9.32874,0 16.8897,-7.55639 16.8897,-16.88968 v -12.41027 h 7.08927 c 9.51661,0 17.35203,-7.74418 17.35203,-17.35204 v -5.784084 c 0,-13.807421 -11.19732,-25.095986 -25.09597,-25.095986 h -78.28022 c -13.90358,0 -25.09597,11.288814 -25.09597,25.095986 v 5.784084 c 0,9.60811 7.83578,17.35204 17.4482,17.35204 h 6.99778 V 132.444 c 0,9.32873 7.55641,16.88969 16.8897,16.88969 h 1.86379 v 24.35006 h -30.97697 c -11.19734,0 -20.33816,8.86158 -20.9016,19.87088 H 86.267199 c -11.19733,0 -21.739983,4.38745 -29.671323,12.31473 l -45.064262,45.0692 c -4.0117801,4.01177 -6.251247,9.32873 -6.251247,15.02183 0,5.69261 2.2394669,11.00955 6.251247,15.02182 l 2.894514,2.986 c 4.199554,4.10327 9.608103,6.15977 15.113068,6.15977 5.413234,0 10.821661,-2.0517 15.021832,-6.15977 l 43.66737,-43.75861 h 56.820112 c 0.55866,10.07526 8.11504,18.28659 17.91549,19.68841 v 8.02358 c 0,13.4363 -10.91808,24.35005 -24.35008,24.35005 h -14.83319 c -24.446243,0 -44.317123,19.87089 -44.317123,44.31712 v 288.02119 c 0,24.44624 19.87088,44.31712 44.317123,44.31712 h 188.37702 c 24.44623,0 44.31712,-19.87088 44.31712,-44.31712 l -0.005,-288.02119 c 0,-24.44623 -19.87088,-44.31712 -44.31713,-44.31712 h -14.83319 c -13.4363,0 -24.35006,-10.91806 -24.35006,-24.35005 v -8.02358 c 8.21145,-1.21364 14.83319,-7.08925 17.0734,-14.83318 h 4.29116 c 12.22324,0 22.29849,-9.23724 23.88278,-21.18149 h 15.11308 v 1.30517 c 0,4.84979 2.14798,9.42502 5.87558,12.50299 2.986,2.51884 6.6221,3.82401 10.45092,3.82401 1.02582,0 2.05169,-0.0915 3.07747,-0.37083 l 20.71421,-3.9203 c 7.6527,-1.49293 13.2489,-8.21147 13.2489,-16.04762 v -8.58219 c 0,-7.74912 -5.59632,-14.5595 -13.24397,-15.95515 z M 195.04838,135.3334 c -1.58455,0 -2.89452,-1.30516 -2.89452,-2.89451 v -12.41053 h 51.59501 v 12.41053 c 0,1.58453 -1.30517,2.89451 -2.89452,2.89451 z m 29.95119,13.99605 v 24.35007 l -14.08729,0.005 v -24.35006 z m 72.30797,156.93771 h 14.8332 c 16.70229,0 30.3223,13.62 30.3223,30.3223 v 288.02118 c 0,16.7023 -13.62001,30.32231 -30.3223,30.32231 l -188.37702,0.005 c -16.7023,0 -30.322311,-13.62 -30.322311,-30.3223 V 336.59439 c 0,-16.7023 13.620011,-30.3223 30.322311,-30.3223 h 14.83319 c 21.18148,0 38.34611,-17.16957 38.34611,-38.34612 v -7.74418 h 82.01349 v 7.74418 c 0.005,21.17655 17.1745,38.34612 38.34981,38.34612 z m -20.33815,-67.08289 c 0,3.82401 -3.07749,6.99777 -6.99777,6.99777 H 165.9395 c -3.92029,0 -6.99778,-3.17376 -6.99778,-6.99777 v -44.50576 c 0,-3.82401 3.07749,-6.99777 6.99778,-6.99777 h 104.03212 c 3.92028,0 6.99777,3.17376 6.99777,6.99777 z m 27.52359,-18.29153 c 0,5.59633 -4.57043,10.17155 -10.17155,10.17155 h -3.35686 v -28.27073 h 3.35686 c 5.59632,0 10.17155,4.57041 10.17155,10.17155 z',
            $this->frameId()
        );
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-17.5%%, 21%%) scale(1.9);
        }

        #%2$s path {
            transform: scale(0.75);
        }
        
        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor
        );
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
