<?php

namespace App\Support\SoftwareUpdate\MandatorySeeders;

use App\Models\OfflinePaymentGatewayModel;
use App\Models\PaypalPaymentGateway;
use App\Models\StripePaymentGatewayModel;
use Illuminate\Support\Facades\Log;

use Database\Seeders\PaymentGatewaySeeder as DatabaseSeeder;

class PaymentGatewaySeeder extends Seeder
{
    protected function run()
    {
        $this->seedPayPal();

        $this->seedStripe();

        $this->seedOfflinePaymentGateway();
    }

    private function seedPayPal()
    {
        if (PaypalPaymentGateway::instance()) {
            return;
        }

        $paymentGateway = new PaypalPaymentGateway();


        $paymentGateway->mode = PaypalPaymentGateway::MODE_SANDBOX;
        $paymentGateway->enabled = false;
        $paymentGateway->name = 'PayPal';
        $paymentGateway->slug = strtolower(PaypalPaymentGateway::SLUG);

        $paymentGateway->client_id = env('PAYPAL_SANDBOX_CLIENT_ID');

        $paymentGateway->client_secret = env('PAYPAL_SANDBOX_CLIENT_SECRET');

        $paymentGateway->save();

        $paymentGateway->refresh();
    }

    private function seedStripe()
    {
        if (StripePaymentGatewayModel::instance()) {
            return;
        }

        $paymentGateway = new StripePaymentGatewayModel();

        $paymentGateway->mode = 'live';
        $paymentGateway->enabled = false;
        $paymentGateway->name = 'Stripe';
        $paymentGateway->slug = strtolower(StripePaymentGatewayModel::SLUG);

        $paymentGateway->publisher_key = env('STRIPE_PUBLISHER_KEY');

        $paymentGateway->secret_key = env('STRIPE_SECRET_KEY');

        $paymentGateway->save();

        $paymentGateway->refresh();
    }

    public function seedOfflinePaymentGateway()
    {
        $seeder = new DatabaseSeeder();

        $seeder->seedOfflinePaymentGateway();
    }
}
