<?php

namespace App\Support\SoftwareUpdate\MandatorySeeders;

use App\Exceptions\NotImplementedException;
use App\Models\Config;
use Illuminate\Support\Facades\DB;

abstract class Seeder
{
    protected $rawFile = '';

    protected $table = '';

    protected $runOnce = false;

    protected $didRun = false;

    protected function run()
    {
        foreach ($this->getRawArray() as $row) {
            if ($this->shouldInsertRow($row)) {

                $data = array_merge($row, [
                    'id' => null,
                ]);

                $model = $this->newModel();

                $model->forceFill($data);

                $model->save();
            }
        }
    }

    protected function newModel()
    {
        throw new NotImplementedException();
    }

    protected function shouldInsertRow(array $row)
    {
        throw new NotImplementedException();
    }

    public function seed()
    {
        $this->beforeRun();

        if ($this->runOnce) {
            if (empty(Config::get($this->lastRunConfigKey()))) {
                $this->run();
                $this->didRun = true;
            }
        } else {
            $this->run();
            $this->didRun = true;
        }

        $this->afterRun();

        $this->terminate();
    }

    protected function terminate()
    {
        if ($this->didRun)
            Config::set($this->lastRunConfigKey(), now());
    }

    protected function lastRunConfigKey()
    {
        return static::class . '::lastRun';
    }

    protected function beforeRun()
    {
    }

    protected function afterRun()
    {
    }

    protected function getRawArray()
    {
        $array = require(base_path('database/raw/' . $this->rawFile . '.php'));

        return $array;
    }

    protected function rawFile($name)
    {
        return file_get_contents(base_path('database/raw/' . $name));
    }
}
