<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class QRCodeScanFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            "ip_address" => $this->faker->ipv4(),
            "device_name" => "desktop",
            "device_brand" => "Apple",
            "device_model" => "",
            "os_name" => "Mac",
            "os_version" => "10.15",
            "client_type" => "browser",
            "client_name" => "Chrome",
            "client_version" => "99.0",
            "created_at" => $this->faker->dateTimeBetween($startDate = '-10 days', $endDate = 'now'),
        ];
    }
}
