<?php

namespace Database\Seeders;

use App\Models\OfflinePaymentGatewayModel;
use App\Models\PaymentGateway;
use App\Models\PaypalPaymentGateway;
use App\Models\StripePaymentGatewayModel;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Log;


class PaymentGatewaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->seedPaypal();
        $this->seedStripe();

        $this->seedOfflinePaymentGateway();
    }

    private function seedPayPal()
    {
        if (PaypalPaymentGateway::instance()) {
            $paymentGateway = PaypalPaymentGateway::instance();
        } else {
            $paymentGateway = new PaypalPaymentGateway();
        }

        $paymentGateway->mode = PaypalPaymentGateway::MODE_SANDBOX;
        $paymentGateway->enabled = true;
        $paymentGateway->name = 'PayPal';
        $paymentGateway->slug = strtolower(PaypalPaymentGateway::SLUG);

        $paymentGateway->client_id = env('PAYPAL_SANDBOX_CLIENT_ID');

        $paymentGateway->client_secret = env('PAYPAL_SANDBOX_CLIENT_SECRET');

        $paymentGateway->save();

        $paymentGateway->refresh();
    }

    private function seedStripe()
    {
        if (StripePaymentGatewayModel::instance()) {
            $paymentGateway = StripePaymentGatewayModel::instance();
        } else {
            $paymentGateway = new StripePaymentGatewayModel();
        }

        $paymentGateway->mode = 'live';
        $paymentGateway->enabled = true;
        $paymentGateway->name = 'Stripe';
        $paymentGateway->slug = strtolower(StripePaymentGatewayModel::SLUG);

        $paymentGateway->publisher_key = env('STRIPE_PUBLISHER_KEY');

        $paymentGateway->secret_key = env('STRIPE_SECRET_KEY');

        $paymentGateway->save();

        $paymentGateway->refresh();
    }

    public function seedOfflinePaymentGateway()
    {
        if (OfflinePaymentGatewayModel::instance()) {
            return;
        }

        $gateway = new OfflinePaymentGatewayModel;

        $gateway->mode = 'live';

        $gateway->enabled = false;

        $gateway->name = 'Offline Payment Gateway';

        $gateway->slug = OfflinePaymentGatewayModel::SLUG;

        $gateway->customer_instructions = 'Please transfer the payment to our bank account:
- Account Name: Acme Inc.
- Account Number: 0000000000000.
- Bank Name: Central Bank.
- Attach the receipt below.
- **You can change this from [Offline Payment Gateway Settings](/dashboard/payment-gateways/edit/3).**';

        $gateway->save();

        $gateway->refresh();
    }
}
