<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

use App\Models\QRCode;
use App\Models\QRCodeScan;

use Carbon\Carbon;

class QRCodeScanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $qrcodes = QRCode::with('redirect')->whereHas('redirect')->get();

        foreach ($qrcodes as $qrcode) {
            QRCodeScan::factory()->count(5)->state([
                "qrcode_redirect_id" => $qrcode->redirect->id,
                "qrcode_id" => $qrcode->id,
            ])->create();
        }
    }
}
