<?php

namespace Database\Seeders;

use App\Interfaces\FileManager;
use App\Models\File;
use App\Models\Translation;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Log;

class TranslationSeeder extends Seeder
{
    private FileManager $files;

    public function __construct()
    {
        $this->files = app(FileManager::class);
    }

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $translations = require_once(__DIR__ . '/../raw/translations.php');

        if (app()->environment() === 'demo') {
            File::where('attachable_type', Translation::class)->get()->each(function ($file) {
                $file->delete();
            });

            Log::info('Old translation files are cleared');
        }

        foreach ($translations as $translation) {

            $model = new Translation([
                'name' => $translation['name'],
                'locale' => $translation['locale']
            ]);

            $model->is_default = $translation['is_default'];

            $model->is_active = $translation['is_active'];

            $model->save();

            $data = file_get_contents(__DIR__ . "/../raw/translation-{$model->locale}.json");

            $this->files->save(
                name: "translation-{$model->locale}.json",
                type: FileManager::FILE_TYPE_TRANSLATION,
                mime_type: 'text/plain;charset=UTF-8',
                attachable_type: Translation::class,
                attachable_id: $model->id,
                user_id: 1,
                extension: 'json',
                data: $data
            );
        }
    }
}
