<?php

use App\Models\User;
use App\Models\Page;
use App\Models\QRCode;
use App\Models\BlogPost;
use App\Models\Subscription;
use App\Models\PaymentGateway;
use App\Models\SubscriptionPlan;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\BlogPostController;
use App\Http\Controllers\CaptchaController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\ContentBlockController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\CustomCodeController;
use App\Http\Controllers\FilesController;
use App\Http\Controllers\InstallController;
use App\Http\Controllers\MarkdownController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\QRCodeController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\PaymentGatewayController;
use App\Http\Controllers\QRCodeScanController;
use App\Http\Controllers\RolesController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\SubscriptionPlanController;
use App\Http\Controllers\SystemController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\TranslationController;
use App\Models\Contact;
use App\Models\ContentBlock;
use App\Models\Currency;
use App\Models\CustomCode;
use App\Models\Translation;
use App\Support\GoogleFonts;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::prefix('/install')->group(function () {
    Route::post('/save', [InstallController::class, 'saveEnvVariables']);

    Route::post('/load', [InstallController::class, 'loadEnvVariables']);

    Route::post('/verify-database', [InstallController::class, 'verifyDatabase']);

    Route::post('/verify-mail', [InstallController::class, 'verifyMail']);

    Route::post('/verify-purchase-code', [InstallController::class, 'verifyPurchaseCode']);

    Route::post('/complete', [InstallController::class, 'completeInstallation']);
});

Route::post('/login', [AccountController::class, 'login']);

Route::post('/register', [AccountController::class, 'register']);

Route::post('/forgot-password', [AccountController::class, 'forgotPassword']);

Route::post('/reset-password', [AccountController::class, 'resetPassword']);

Route::get('/qrcodes/preview', [QRCodeController::class, 'preview']);

Route::get('/captcha', [CaptchaController::class, 'getCaptcha']);

Route::get('/fonts', function () {
    $fonts = new GoogleFonts();

    return $fonts->listFamilies();
});

Route::post(
    '/account/resend-verification-email',
    [AccountController::class, 'resendVerificationEmail']
)->middleware(['auth:sanctum', 'throttle:6,1']);

Route::get('/myself', [AccountController::class, 'myself'])->middleware(['auth:sanctum']);

Route::get(
    '/subscription-plans',
    [SubscriptionPlanController::class, 'index']
);

Route::get(
    '/subscription-plans/{subscriptionPlan}',
    [SubscriptionPlanController::class, 'show']
);

Route::get(
    '/files/{file:slug}/resource',
    [FilesController::class, 'resource']
);

Route::post(
    '/contacts',
    [
        ContactController::class,
        'store'
    ]
);

Route::middleware(['auth:sanctum', 'verified'])->group(function () {

    Route::crud(
        '/qrcodes',
        QRCodeController::class,
        QRCode::class
    );

    Route::post(
        '/qrcodes/archive/{qrcode}',
        [QRCodeController::class, 'archive']
    )->can('archive,qrcode');

    Route::post(
        '/qrcodes/{qrcode}/copy',
        [QRCodeController::class, 'copy']
    );

    Route::get(
        '/qrcodes/stats/{qrcode}',
        [QRCodeController::class, 'stats']
    )->can('showStats,qrcode');

    Route::post(
        '/qrcodes/{qrcode}/logo',
        [QRCodeController::class, 'storeLogo']
    );

    Route::post(
        '/qrcodes/{qrcode}/background-image',
        [QRCodeController::class, 'storeForegroundImage']
    );

    Route::crud(
        '/users',
        UsersController::class,
        User::class
    );

    Route::crud(
        '/subscription-plans',
        SubscriptionPlanController::class,
        SubscriptionPlan::class,
        except: ['index', 'show']
    );

    Route::get(
        '/payment-gateways',
        [PaymentGatewayController::class, 'index']
    );

    Route::crud(
        '/payment-gateways',
        PaymentGatewayController::class,
        PaymentGateway::class,
        only: ['update', 'show']
    );

    Route::get(
        '/subscriptions/statuses',
        [SubscriptionController::class, 'listStatuses']
    );

    Route::crud(
        '/subscriptions',
        SubscriptionController::class,
        Subscription::class,
        only: ['index', 'show', 'store', 'update']
    );

    Route::post('/subscriptions/subscribe', [SubscriptionController::class, 'subscribe']);

    Route::post(
        '/subscriptions/activate/{subscription}',
        [SubscriptionController::class, 'activate']
    )->can('activate,subscription');

    Route::put(
        '/subscriptions/{subscription}/update-paypal-ids',
        [SubscriptionController::class, 'updatePayPalIds']
    );

    Route::get(
        '/transactions',
        [TransactionController::class, 'index']
    )->can('list,App\Models\Transaction');

    Route::post(
        '/transactions/upload-proof-of-payment',
        [TransactionController::class, 'uploadProofOfPayment']
    );

    Route::post(
        '/transactions/offline-transaction',
        [TransactionController::class, 'storeOfflineTransaction']
    );

    Route::post(
        '/transactions/{transaction}/approve',
        [TransactionController::class, 'approveOfflineTransaction']
    )->can('approve,transaction');

    Route::post(
        '/transactions/{transaction}/reject',
        [TransactionController::class, 'rejectOfflineTransaction']
    )->can('reject,transaction');


    Route::get(
        '/qrcode-scans/count',
        [QRCodeScanController::class, 'count']
    );

    Route::crud(
        '/files',
        FilesController::class,
        File::class,
        only: ['show', 'destroy']
    );

    Route::crud(
        '/blog-posts',
        BlogPostController::class,
        BlogPost::class
    );

    Route::post(
        '/markdown',
        MarkdownController::class
    );

    Route::crud(
        '/content-blocks',
        ContentBlockController::class,
        ContentBlock::class
    );

    Route::crud(
        '/contacts',
        ContactController::class,
        Contact::class,
        except: ['store']
    );

    Route::get(
        '/system/status',
        [SystemController::class, 'status']
    )->can('system.status');

    Route::get(
        '/system/check_database_update',
        [SystemController::class, 'checkDatabaseUpdate']
    )->can('system.status');

    Route::post(
        '/system/update_database',
        [SystemController::class, 'updateDatabase']
    )->can('system.status');

    Route::get(
        '/system/configs',
        [SystemController::class, 'getConfigs']
    );

    Route::post(
        '/system/configs',
        [SystemController::class, 'saveConfigs']
    );

    Route::post(
        '/system/configs/upload',
        [SystemController::class, 'uploadConfigAttachment']
    );

    Route::get(
        '/system/timezones',
        [SystemController::class, 'getTimezones']
    );

    Route::get(
        '/translations/can-auto-translate',
        [TranslationController::class, 'canAutoTranslate']
    );

    Route::crud(
        '/translations',
        TranslationController::class,
        Translation::class,
    );

    Route::post(
        '/translations/{translation}/upload',
        [TranslationController::class, 'upload']
    );

    Route::post(
        '/translations/{translation}/activate',
        [TranslationController::class, 'activate']
    );

    Route::post(
        '/translations/{translation}/auto-translate',
        [TranslationController::class, 'autoTranslate']
    );

    Route::post(
        '/checkout/stripe/{subscription}',
        [CheckoutController::class, 'stripeCheckout']
    );

    Route::post(
        '/checkout/stripe/verify-checkout-session/{sessionId}',
        [CheckoutController::class, 'stripeVerifyCheckoutSession']
    );

    Route::get(
        '/roles',
        [RolesController::class, 'index']
    )->can('list,App\Models\Role');

    Route::crud(
        '/currencies',
        CurrencyController::class,
        Currency::class
    );

    Route::post(
        '/currencies/{currency}/enable',
        [CurrencyController::class, 'enableCurrency']
    )->can('enable,currency');

    Route::get(
        '/custom-codes/positions',
        [CustomCodeController::class, 'getPositions']
    );

    Route::crud(
        '/custom-codes',
        CustomCodeController::class,
        CustomCode::class
    );

    Route::crud(
        '/pages',
        PageController::class,
        Page::class
    );
});
