<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AccountController;
use App\Http\Controllers\BlogPostController;
use App\Http\Controllers\QRCodeRedirectController;
use App\Http\Controllers\SystemController;
use App\Interfaces\BlogPostManager;
use App\Support\PageManager;
use App\Support\SitemapGenerator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function (BlogPostManager $posts, Request $request) {
    if (frontend_custom_url()) {
        return redirect(frontend_custom_url());
    }

    return view('index', [
        'recentPosts' => $posts->recentPosts($request)
    ]);
});

Route::get('/dashboard/qrcodes/designer/preview', function () {
    return view('qrcode.designer-preview');
});

Route::get('/{frontend}', function () {
    return view('frontend-routes');
})->where('frontend', '^(dashboard|account|install|checkout|pricing-plans).*');


Route::get('/sitemap.xml', function () {
    return view('sitemap', [
        'urls' => SitemapGenerator::generate()
    ]);
});

Route::get('/blog/post/{post:slug}', [BlogPostController::class, 'viewPost'])->name('post');

Route::get('/blog', [BlogPostController::class, 'viewArchive'])->name('blog');

Route::get('/email/verify/{id}/{hash}', [AccountController::class, 'verifyEmail'])
    ->middleware(['signed'])
    ->name('verification.verify');

Route::get('/login', function () {
    return redirect(config('frontend.url') . '/account/login');
})->name('login');

Route::get('/scan/{slug}', [QRCodeRedirectController::class, 'index'])->name('qrcode.redirect');

Route::get('/system/cron', [SystemController::class, 'cron'])->name('cron');

Route::get('/api-docs', function () {
    return file_get_contents(resource_path('views/api-docs/api-docs.html'));
});

Route::get('/robots.txt', function () {
    return view('robots');
});

Route::get('/smtp-test', function (Request $request) {

    if (!env('ENABLE_SMTP_TEST')) {
        return abort(404);
    }

    $to = $request->to ?? 'mohammad.a.alhomsi@gmail.com';

    $message = Mail::raw(
        'We have sent this email successfully using SMTP protocol.',
        function ($message) use ($to) {
            $message->to($to);
            $message->subject('SMTP Test');
        }
    );

    return $message->getSymfonySentMessage()->getDebug();
});

/**
 * No routes should be added after page manager route registration other than 
 * static routes, because dynamic pages override routes based on client inputs.
 */



Route::middleware(['custom_frontend_redirector'])->group(function () {

    Route::get('/about', function () {
        return view('inner-page.about');
    });

    Route::get('/contact', function () {
        return view('inner-page.contact');
    });

    Route::get('/terms-and-conditions', function () {
        return view('inner-page.terms-and-conditions');
    });

    Route::get('/privacy-policy', function () {
        return view('inner-page.privacy-policy');
    });

    PageManager::registerRoutes();
});
